/*******************************************************************************
*   touch.h
*   Atmel Corporation:  http://www.atmel.com \n
*   Support email:  touch@atmel.com
******************************************************************************/
/*  License
*   Copyright (c) 2010, Atmel Corporation All rights reserved.
*
*   Redistribution and use in source and binary forms, with or without
*   modification, are permitted provided that the following conditions are met:
*
*   1. Redistributions of source code must retain the above copyright notice,
*   this list of conditions and the following disclaimer.
*
*   2. Redistributions in binary form must reproduce the above copyright notice,
*   this list of conditions and the following disclaimer in the documentation
*   and/or other materials provided with the distribution.
*
*   3. The name of ATMEL may not be used to endorse or promote products derived
*   from this software without specific prior written permission.
*
*   THIS SOFTWARE IS PROVIDED BY ATMEL "AS IS" AND ANY EXPRESS OR IMPLIED
*   WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
*   MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE EXPRESSLY AND
*   SPECIFICALLY DISCLAIMED. IN NO EVENT SHALL ATMEL BE LIABLE FOR ANY DIRECT,
*   INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
*   (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
*   LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
*   ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
*   (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
*   THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
/*  This is an automatically generated file. Do not modify the contents manually.
    Instead, use the Project Builder Wizard to make changes to the design.
*/
#include <avr/io.h>
#include <avr/interrupt.h>

#define __enable_interrupt()  sei()
#define __delay_cycles(n)     __builtin_avr_delay_cycles(n)

#include "touch_api.h"
#include "touch.h"

/*----------------------------------------------------------------------------
                                prototypes
----------------------------------------------------------------------------*/

/*  Assign the parameters values to global configuration parameter structure    */
static void qt_set_parameters( void );
/*  Configure the sensors */
static void config_sensors(void);

/*----------------------------------------------------------------------------
                                extern variables
----------------------------------------------------------------------------*/
/* This configuration data structure parameters if needs to be changed will be
   changed in the qt_set_parameters function */
extern qt_touch_lib_config_data_t qt_config_data;
/* touch output - measurement data */
extern qt_touch_lib_measure_data_t qt_measure_data;
/* Get sensor delta values */
extern int16_t qt_get_sensor_delta( uint8_t sensor);
#ifdef QTOUCH_STUDIO_MASKS
extern TOUCH_DATA_T SNS_array[2][2];
extern TOUCH_DATA_T SNSK_array[2][2];
#endif

extern uint8_t time_to_measure_touch;
extern uint16_t current_time_ms_touch;

/* Output can be observed in the watch window using this pointer */
qt_touch_lib_measure_data_t *pqt_measure_data = &qt_measure_data;


/*----------------------------------------------------------------------------
                                static variables
----------------------------------------------------------------------------*/

/*============================================================================
Name    :   touch_init
------------------------------------------------------------------------------
Purpose :   Initializes touch related code.
============================================================================*/

void touch_init( void )
{
	#ifdef QTOUCH_STUDIO_MASKS
	SNS_array[0][0]= 0x47;
	SNS_array[0][1]= 0x38;
	SNS_array[1][0]= 0x0;
	SNS_array[1][1]= 0x0;

	SNSK_array[0][0]= 0x47;
	SNSK_array[0][1]= 0x38;
	SNSK_array[1][0]= 0x0;
	SNSK_array[1][1]= 0x0;
	#endif
	
    /* Configure the Sensors as one Rotor and one Slider */
    config_sensors();

    /* Initialize touch sensing */
    qt_init_sensing();

    /*  Set parameters like recalibration threshold, Detect Integration etc */
    qt_set_parameters( );

    qt_filter_callback = 0;

    /* enable interrupts */
    __enable_interrupt();

}


/*============================================================================
Name    :   touch_measure
------------------------------------------------------------------------------
Purpose :   This will call all the functions for touch related measurement.
============================================================================*/

void touch_measure()
{

	/*status flags to indicate the re-burst for library*/
    static uint16_t status_flag = 0u;
    static uint16_t burst_flag = 0u;

	  if( time_to_measure_touch )
        {

            /*  clear flag: it's time to measure touch  */
            time_to_measure_touch = 0u;

            do {
                /*  one time measure touch sensors    */
                status_flag = qt_measure_sensors( current_time_ms_touch );

                burst_flag = status_flag & QTLIB_BURST_AGAIN;

			}while (burst_flag) ;

        }
}


/*============================================================================
Name    :   qt_set_parameters
------------------------------------------------------------------------------
Purpose :   Default threshold values.
============================================================================*/

static void qt_set_parameters( void )
{
	/* When counter reaches 2, it is detected as touch */
	qt_config_data.qt_di              = 2;
	/* Accounts for adjusting the reference level. In units of 200ms */
	qt_config_data.qt_neg_drift_rate  = 20;
	qt_config_data.qt_pos_drift_rate  = 5;
	/* In units of 200ms. When 0, no recalibration occurs */
	qt_config_data.qt_max_on_duration = 0;
	/* Restrict drift on all sensors. Units of 200ms */
	qt_config_data.qt_drift_hold_time = 20;
	/* Automatic recalibration after 50% of detection threshold */
	qt_config_data.qt_recal_threshold = 1;
	qt_config_data.qt_pos_recal_delay = 0;
}

/*============================================================================
Name    :   config_sensors -
------------------------------------------------------------------------------
Purpose :   Configure the sensors
============================================================================*/
static void config_sensors(void)
{
	/* Detect threshold of 10 indicates the signal level has to fall 10 units below reference to be detected */
	/* Hysteresis is 6.25% of detect threshold. */
	/* 8-bit resolution reads values from 0-255 */
	/* Angle/Position Hysteresis of 0 */
	qt_enable_slider( CHANNEL_0, CHANNEL_2, NO_AKS_GROUP, 10u, HYST_6_25, RES_8_BIT, 0u  );
	qt_enable_key( CHANNEL_6, NO_AKS_GROUP, 10u, RES_8_BIT);
	qt_enable_rotor( CHANNEL_3, CHANNEL_5, NO_AKS_GROUP, 10u, HYST_6_25, RES_8_BIT, 0u );

}


